import hxvlc.flixel.FlxVideoSprite;

// import funkin.menus.PauseSubState;

var rainbow:CustomShader = new CustomShader("rainbow");
var rainbowActive = false;
var bloom:CustomShader = new CustomShader("Bloom");
var awesomeBloom = false;
var bloomaMount = 1;

// TODO@xavi.: make one sheet instead of loading 8 individual images.
var frame1 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv1.png");
var frame2 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv2.png");
var frame3 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv3.png");
var frame4 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv4.png");
var frame5 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv5.png");
var frame6 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv6.png");
var frame7 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv7.png");
var frame8 = new FlxSprite().loadGraphic("images/stages/weegee/ytpmv8.png");
if (FlxG.save.data.midsongvids_toggle) {
	var intro = new FlxVideoSprite(0, 0);

	intro.autoPause = false;
	intro.load(Assets.getPath(Paths.video("anchored-intro")));
	intro.visible = false;
}
function create() {
	if (FlxG.save.data.midsongvids_toggle) {
		intro.bitmap.onFormatSetup.add(function() {
			intro.cameras = [camHUD2];
			intro.scale.set(1.5, 1.5);
			intro.updateHitbox();
		});
		add(intro);
	}
}

function postCreate() {
	if (FlxG.save.data.midsongvids_toggle)
		camGame.visible = false;
	camHUD.visible = false;
	for (i in [frame1, frame2, frame3, frame4, frame5, frame6, frame7, frame8]) {
		i.cameras = [camHUD2];
		i.screenCenter();
		i.visible = false;
		add(i);
	}
}

var time:Float = 0;

function update(elapsed) {
	bloomaMount = FlxMath.lerp(bloomaMount, 1, elapsed * 1.5);
	bloom.data.dim.value = [bloomaMount, bloomaMount];
	if (rainbowActive) {
		rainbow.iTime = time;
		time += elapsed * 1.5;
	}
}

/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
var videosToHandle:Array<FlxVideoSprite> = [intro];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}

function beatHit(beat) {
	if (beat % 2 == 0 && awesomeBloom)
		bloomaMount = 0.7;
}

function stepHit(step) {
	switch (step) {
		case 0:
			if (FlxG.save.data.midsongvids_toggle) {
				intro.play();
				intro.visible = true;
			}
		case 256:
			camHUD.visible = true;
			if (FlxG.save.data.midsongvids_toggle) {
				camGame.visible = true;
				intro.visible = false;
				remove(intro);
			}
		case 1152:
			camGame.visible = false;
			camHUD.visible = false;
			frame1.visible = true;
		case 1154:
			frame1.visible = false;
			frame2.visible = true;
		case 1156:
			frame2.visible = false;
			frame3.visible = true;
		case 1158:
			frame3.visible = false;
			frame4.visible = true;
		case 1160:
			frame4.visible = false;
			frame5.visible = true;
		case 1162:
			frame5.visible = false;
			frame6.visible = true;
		case 1164:
			frame6.visible = false;
			frame7.visible = true;
		case 1166:
			frame7.visible = false;
			frame8.visible = true;
		case 1168:
			camGame.visible = true;
			for (i in [frame1, frame2, frame3, frame4, frame5, frame6, frame7, frame8]) {
				remove(i);
				i.destroy();
			}
			camGame.followLerp = 0.05;
			camHUD.visible = true;

			if (FlxG.save.data.flashing_toggle) {
				camGame.addShader(rainbow);
				camHUD.addShader(rainbow);
				rainbowActive = true;
			}

		case 1440:
			rainbowActive = false;
			camGame.removeShader(rainbow);
			camHUD.removeShader(rainbow);
			if (FlxG.save.data.flashing_toggle) {
				camGame.addShader(bloom);
				awesomeBloom = true;
			}
		case 1696:
			camGame.visible = false;
			awesomeBloom = false;
			camGame.followLerp = 0.04;
			camGame.removeShader(bloom);
		case 1712:
			camGame.visible = true;
		case 1968:
			FlxTween.tween(camHUD, {alpha: 0.001}, 1.5, {ease: FlxEase.cubeIn});
	}
}

function onGameOver() {
	if (!camGame.visible)
		camGame.visible = true;
}
